﻿<?php

/** Variables que recibo del Formulario y Sanitize **/
$prename = filter_var(utf8_decode($_POST['prename']), FILTER_SANITIZE_STRING);
$name = filter_var(utf8_decode($_POST['name']), FILTER_SANITIZE_STRING);
$telf = filter_var(utf8_decode($_POST['phone']), FILTER_SANITIZE_NUMBER_INT);
$email = filter_var(utf8_decode($_POST['email']), FILTER_SANITIZE_EMAIL);
$message = filter_var(utf8_decode($_POST['message']), FILTER_SANITIZE_STRING);
$lang = filter_var(utf8_decode($_POST['lang']), FILTER_SANITIZE_STRING);

/*** Validacion email ***/
if ( !filter_var($email, FILTER_VALIDATE_EMAIL) ) {
  echo 'error';
  die();
}

if (empty($lang)) {
  $lang = 'fr';
}

switch ($lang) {

  case 'es':
    $subject = 'Contacto Web SGR';
    $h1 = 'Contacto SGR - Holidays Home Services';
    $text_name = 'Nombre';
    $text_first = 'Apellidos';
    $text_phone = 'Tel&eacute;fono';
    $text_message = 'Mensaje';
    break;
  case 'ca':
    $subject = 'Contacte Web SGR';
    $h1 = 'Contacte SGR - Holidays Home Services';
    $text_name = 'Nom';
    $text_first = 'Cognoms';
    $text_phone = 'Tel&eacute;fon';
    $text_message = 'Missatge';
    break;
  case 'de':
    $subject = 'Kontakt Web SGR';
    $h1 = 'Contact SGR - Holidays Home Services';
    $text_name = 'Name';
    $text_first = 'Vorname';
    $text_phone = 'Telefon';
    $text_message = 'Ihre Nachricht';
    break;
  case 'en':
    $subject = 'Contact Web SGR';
    $h1 = 'Contact SGR - Holidays Home Services';
    $text_name = 'Name';
    $text_first = 'First Name';
    $text_phone = 'Phone';
    $text_message = 'Message';
    break;
  case 'fr':
  default:
    $subject = 'Contact Web SGR';
    $h1 = 'Contact SGR - Holidays Home Services';
    $text_name = 'Non';
    $text_first = 'Pr&eacute;nom';
    $text_phone = 'Tel&eacute;phone';
    $text_message = 'Demandes';
    break;
}


/** PHPMAILER CONFIGURACION **/
require_once('class.phpmailer.php');

$mail = new PHPMailer(true);

$mail->IsSMTP();
$mail->SMTPAuth   = true;                  // enable SMTP authentication
$mail->Port       = 25;                    // set the SMTP port for the GMAIL server
$mail->Username   = "no-reply@sgr-services.com"; // SMTP account username
$mail->Password   = "3fXNrsTx])(y";        // SMTP account password
$mail->Host       = "mail.sgr-services.com"; // SMTP server

$mail->IsHTML(true); 

$mail->SetFrom('no-reply@sgr-services.com', 'SGR - Holidays Home Services');
$mail->Subject = $subject;
$mail->addReplyTo($email);
$mail->AddAddress('info@sgr-services.com');  //Persona que el rep.

$codigohtml = '
  <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title></title>
</head>
<body>
<h1>' . $h1 . '</h1>
<div>
  <p><strong>' . $text_name . ': </strong>' . $name . '</p>
  <p><strong>' . $text_first .': </strong>' . $prename . '</p>
  <p><strong>' . $text_phone . ': </strong>' . $telf . '</p>
  <p><strong>Email: </strong>' . $email . '</p>
  <p><strong>' . $text_message . ':</strong><br />' . $message . '</p>
</body>
</html>';

$mail->MsgHTML($codigohtml);

$mail->isSendMail(); /* Para conectarse a un servidor de correo externo */

if($mail->Send())
  echo "ok";
else
  echo 'error';